//
//  $Id: AHKMMainWindowController_Toolbar.m 96 2009-06-11 17:01:30Z fujidana $
//  Copyright (c) 2006-2009 Fujidana All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKMMainWindowController.h"


static NSString* AHKMToolbarIdentifier = @"Mail Utility Toolbar Identifier";

//static NSString* AHKMToolbarNewItemIdentifier = @"New Card Item Identifier";
static NSString* AHKToolbarDeleteItemIdentifier = @"Delete Card Item Identifier";
//static NSString* AHKToolbarInspectorItemIdentifier = @"Inspector Item Identifier";
static NSString* AHKToolbarSelectPreviousIdentifier = @"Select Previous Item Identifier";
static NSString* AHKToolbarSelectNextIdentifier = @"Select Next Item Identifier";

static NSString* AHKToolbarReceiveItemIdentifier = @"Receive Item Identifier";
//static NSString* AHKToolbarSendItemIdentifier = @"Send Item Identifier";

static NSString* AHKToolbarAddressUtilityItemIdentifier = @"Address Utility Item Identifier";
static NSString* AHKToolbarBookmarkUtilityItemIdentifier = @"Bookmark Utility Item Identifier";
static NSString* AHKToolbarFileUtilityItemIdentifier = @"File Utility Item Identifier";
//static NSString* AHKToolbarMailUtilityItemIdentifier = @"Mail Utility Item Identifier";

static NSString* AHKMToolbarMailboxItemIdentifier = @"Mailbox Item Identifier";


@implementation AHKMMainWindowController (Toolbar)

// this method is called in initialization process
- (void)setupToolbar
{
	NSToolbar *toolbar = [[NSToolbar alloc] initWithIdentifier:AHKMToolbarIdentifier];
    [toolbar setAllowsUserCustomization:YES];
    [toolbar setAutosavesConfiguration:YES];
    [toolbar setDisplayMode:NSToolbarDisplayModeIconAndLabel];
	[toolbar setDelegate:self];
	[[self window] setToolbar:toolbar];
	[toolbar release];
}

#pragma mark delegated method by NSToolbar
- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
	NSToolbarItem *toolbarItem = [[[NSToolbarItem alloc] initWithItemIdentifier:itemIdentifier] autorelease];
//	if ([itemIdentifier isEqual:AHKMToolbarNewItemIdentifier])
//	{
//		[toolbarItem setLabel:NSLocalizedStringFromTable(@"New", @"AHKMLocalizable", @"toolbar.newCard.label")];
//		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"New Message", @"AHKMLocalizable", @"toolbar.newCard.paletteLabel")];
//		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Add a new message.", @"AHKMLocalizable", @"toolbar.newCard.toolTip")];
//		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarNewCardIcon.tiff"]];
//		[toolbarItem setTarget:self];
//		[toolbarItem setAction:@selector(insert:)];
//	}
//	else
	if ([itemIdentifier isEqual:AHKToolbarDeleteItemIdentifier])
	{
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Delete", @"AHKMLocalizable", @"toolbar.delete.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Delete Message", @"AHKMLocalizable", @"toolbar.delete.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Delete selected message(s) from the list.", @"AHKMLocalizable", @"toolbar.delete.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarDeleteIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(delete:)];
	}
//	else if ([itemIdentifier isEqual:AHKToolbarInspectorItemIdentifier])
//	{
//		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Inspector", @"AHKMLocalizable", @"toolbar.inspector.label")];
//		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Show Inspector", @"AHKMLocalizable", @"toolbar.inspector.paletteLabel")];
//		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Show or hide inspector.", @"AHKMLocalizable", @"toolbar.inspector.toolTip")];
//		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarShowInspectorIcon.tiff"]];
//		[toolbarItem setTarget:self];
//		[toolbarItem setAction:@selector(toggleInspector:)];
//	}
	else if ([itemIdentifier isEqual:AHKToolbarSelectPreviousIdentifier])
	{
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Previous", @"AHKMLocalizable", @"toolbar.selectPrevious.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Select Previous", @"AHKMLocalizable", @"toolbar.selectPrevious.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Select Previous Item.", @"AHKMLocalizable", @"toolbar.selectPrevious.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"SelectPrevious.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(selectPrevious:)];
		
	}
	else if ([itemIdentifier isEqual:AHKToolbarSelectNextIdentifier])
	{
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Next", @"AHKMLocalizable", @"toolbar.selectNext.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Select Next", @"AHKMLocalizable", @"toolbar.selectNext.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Select Next Item.", @"AHKMLocalizable", @"toolbar.selectNext.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"SelectNext.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(selectNext:)];
		
	}
	else if ([itemIdentifier isEqual:AHKToolbarReceiveItemIdentifier])
	{
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Receive", @"AHKMLocalizable", @"toolbar.receive.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Receive from Kyopon", @"AHKMLocalizable", @"toolbar.receive.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Receive Data from Kyopon.", @"AHKMLocalizable", @"toolbar.receive.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarReceiveIcon.tiff"]];
		[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(receiveMails:)];
	}
//	else if ([itemIdentifier isEqual:AHKToolbarSendItemIdentifier])
//	{
//		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Send", @"AHKMLocalizable", @"toolbar.send.label")];
//		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Send to Kyopon", @"AHKMLocalizable", @"toolbar.send.paletteLabel")];
//		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Send Data to Kyopon.", @"AHKMLocalizable", @"toolbar.send.toolTip")];
//		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarSendIcon.tiff"]];
//		[toolbarItem setTarget:self];
//		[toolbarItem setAction:@selector(sendPeople:)];
//	}
	else if ([itemIdentifier isEqual:AHKToolbarAddressUtilityItemIdentifier])
	{
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Address Utility", @"AHKMLocalizable", @"toolbar.addressUtility.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Launch Address Utility", @"AHKMLocalizable", @"toolbar.addressUtility.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Launch Kyopon Address Utility.", @"AHKMLocalizable", @"toolbar.addressUtility.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarAddressUtilityIcon.tiff"]];
		//[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(launchAddressUtility:)];
	}
	else if ([itemIdentifier isEqual:AHKToolbarBookmarkUtilityItemIdentifier])
	{
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Bookmark Utility", @"AHKMLocalizable", @"toolbar.bookmarkUtility.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Launch Bookmark Utility", @"AHKMLocalizable", @"toolbar.bookmarkUtility.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Launch Kyopon Bookmark Utility.", @"AHKMLocalizable", @"toolbar.bookmarkUtility.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarBookmarkUtilityIcon.tiff"]];
		//[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(launchBookmarkUtility:)];
	}
	else if ([itemIdentifier isEqual:AHKToolbarFileUtilityItemIdentifier])
	{
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"File Utility", @"AHKMLocalizable", @"toolbar.fileUtility.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Launch File Utility", @"AHKMLocalizable", @"toolbar.fileUtility.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Launch Kyopon File Utility.", @"AHKMLocalizable", @"toolbar.fileUtility.toolTip")];
		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarFileUtilityIcon.tiff"]];
		//[toolbarItem setTarget:self];
		[toolbarItem setAction:@selector(launchFileUtility:)];
	}
//	else if ([itemIdentifier isEqual:AHKToolbarMailUtilityItemIdentifier])
//	{
//		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Mail Utility", @"AHKMLocalizable", @"toolbar.mailUtility.label")];
//		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Launch Mail Utility", @"AHKMLocalizable", @"toolbar.mailUtility.paletteLabel")];
//		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Launch Kyopon Mail Utility.", @"AHKMLocalizable", @"toolbar.mailUtility.toolTip")];
//		[toolbarItem setImage:[NSImage imageNamed:@"ToolbarMailUtilityIcon.tiff"]];
//		//[toolbarItem setTarget:self];
//		[toolbarItem setAction:@selector(launchMailUtility:)];
//	}
	else if ([itemIdentifier isEqual:AHKMToolbarMailboxItemIdentifier])
	{
		[toolbarItem setLabel:NSLocalizedStringFromTable(@"Mailbox", @"AHKMLocalizable", @"toolbar.mailbox.label")];
		[toolbarItem setPaletteLabel:NSLocalizedStringFromTable(@"Mailbox", @"AHKMLocalizable", @"toolbar.mailbox.paletteLabel")];
		[toolbarItem setToolTip:NSLocalizedStringFromTable(@"Set mailbox to be shown.", @"AHKMLocalizable", @"toolbar.mailbox.toolTip")];
		[toolbarItem setView:mailboxView];
		NSRect frame = [mailboxView frame];
		[toolbarItem setMinSize:frame.size];
		[toolbarItem setMaxSize:frame.size];
		
		NSMenuItem *menuItem = [[[NSMenuItem alloc] initWithTitle:NSLocalizedStringFromTable(@"Mailbox", @"AHKMLocalizable", @"toolbar.mailbox.menuForRepresentation") action:0 keyEquivalent:@""] autorelease];
		NSMenu *submenu = [[[NSMenu alloc] initWithTitle:NSLocalizedStringFromTable(@"Mailbox", @"AHKMLocalizable", @"toolbar.mailbox.menuForRepresentation")] autorelease];
		[submenu addItemWithTitle:NSLocalizedStringFromTable(@"All", @"AHKMLocalizable", @"toolbar.mailboxSubMenuForAll.title")
						   action:@selector(showAllMails:)
					keyEquivalent:@""];
		[submenu addItemWithTitle:NSLocalizedStringFromTable(@"Inbox", @"AHKMLocalizable", @"toolbar.mailboxSubMenuForInbox.title")
						   action:@selector(showInboxMails:)
					keyEquivalent:@""];
		[submenu addItemWithTitle:NSLocalizedStringFromTable(@"Outbox", @"AHKMLocalizable", @"toolbar.mailboxSubMenuForOutbox.title")
						   action:@selector(showOutboxMails:)
					keyEquivalent:@""];
		[menuItem setSubmenu:submenu];
		[toolbarItem setMenuFormRepresentation:menuItem];
		
	}
	else
	{
		toolbarItem = nil;
	}
	return toolbarItem;
}

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
			AHKMToolbarMailboxItemIdentifier, 
			NSToolbarSeparatorItemIdentifier,
			AHKToolbarSelectPreviousIdentifier,
			AHKToolbarSelectNextIdentifier,
			// NSToolbarSeparatorItemIdentifier,
			// AHKToolbarDeleteItemIdentifier,
			NSToolbarSeparatorItemIdentifier,
			AHKToolbarReceiveItemIdentifier,
			nil];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
			AHKMToolbarMailboxItemIdentifier, 
			// AHKToolbarDeleteItemIdentifier,
			AHKToolbarSelectPreviousIdentifier,
			AHKToolbarSelectNextIdentifier,
			AHKToolbarReceiveItemIdentifier,
			AHKToolbarAddressUtilityItemIdentifier,
			AHKToolbarBookmarkUtilityItemIdentifier,
			AHKToolbarFileUtilityItemIdentifier,
			// AHKToolbarMailUtilityItemIdentifier,
			NSToolbarPrintItemIdentifier,
			// NSToolbarShowColorsItemIdentifier,
			// NSToolbarShowFontsItemIdentifier, 
			NSToolbarCustomizeToolbarItemIdentifier,
			NSToolbarSeparatorItemIdentifier, 
			NSToolbarSpaceItemIdentifier,
			NSToolbarFlexibleSpaceItemIdentifier, 
			nil];
}

//- (void)toolbarDidRemoveItem:(NSNotification *)notification
//{
//	NSToolbarItem *removedItem = [[notification userInfo] objectForKey:@"item"];
//	if ([[removedItem itemIdentifier] isEqual:AHKToolbarSearchItemIdentifier])
//	{
//		[self searchForString:@"" options:AHKMSearchAll];
//	}
//}

#pragma mark implementation of NSToolbarItemValidation
- (BOOL)validateToolbarItem:(NSToolbarItem *)theItem
{
//	if ([theItem action] == @selector(add:))
//	{
//		return [mailsController canAdd];
//	}
//	else if ([theItem action] == @selector(insert:))
//	{
//		return [mailsController canInsert];
//	}
//	else 
	if ([theItem action] == @selector(delete:))
	{
		return [mailsController canRemove];
	}
	else if ([theItem action] == @selector(selectNext:))
	{
		return [mailsController canSelectNext];
	}
	else if ([theItem action] == @selector(selectPrevious:))
	{
		return [mailsController canSelectPrevious];
	}
//	else if ([theItem action] == @selector(toggleInspector:))
//	{
//		return YES;
//	}
	else if ([theItem action] == @selector(exportSelection:))
	{
		return ([[mailsController selectionIndexes] count] > 0);
	}
	return YES;
}


@end

